# Wilson confidence interval for binomial p
from math import sqrt
def wilson_ci(k, n, z=1.96):
    if n==0:
        return (0.0,0.0,0.0)
    p = k/n
    denom = 1 + z*z/n
    center = (p + z*z/(2*n)) / denom
    half = (z * sqrt(p*(1-p)/n + z*z/(4*n*n))) / denom
    return p, max(0.0, center-half), min(1.0, center+half)
